(* String Output *)
IMPLEMENTATION MODULE SO;

FROM SYSTEM IMPORT ADR;
IMPORT Types, Str;

CONST
  cCR = CHR( 0DH );
  cLF = CHR( 0AH );


PROCEDURE Init( VAR b: TBuffer; VAR s: ARRAY OF CHAR );
BEGIN
  s[0] := 0C;
  b.m := SIZE( s );
  b.s := ADR( s );
  b.l := 0;
  b.c := defConfig;
END Init;

PROCEDURE Reset( VAR b: TBuffer );
BEGIN
  b.s^[0] := 0C;
  b.l := 0;
  b.c := defConfig;
END Reset;

PROCEDURE Clear( VAR b: TBuffer );
BEGIN
  b.s^[0] := 0C;
  b.l := 0;
END Clear;


PROCEDURE WrChar( VAR b: TBuffer; c: CHAR );
VAR
  i: CARDINAL;
BEGIN
  i := b.l;
  IF i >= b.m THEN RETURN END;
  b.s^[ i ] := c;
  INC( i );
  b.l := i;
  IF i < b.m THEN b.s^[ i ] := 0C END;
END WrChar;

PROCEDURE WrCharRep( VAR b: TBuffer; c: CHAR; n: CARDINAL );
VAR
  i: CARDINAL;
BEGIN
  i := b.l;
  WHILE ( i < b.m ) & ( n > 0 ) DO
    b.s^[ i ] := c;
    INC( i );
    DEC( n );
  END;
  b.l := i;
  IF i < b.m THEN b.s^[ i ] := 0C END;
END WrCharRep;


PROCEDURE WrStr( VAR b: TBuffer; s-: ARRAY OF CHAR );
VAR
  i, j: CARDINAL;
  c: CHAR;
BEGIN
  i := b.l;
  j := 0;
  LOOP
    IF ( i >= b.m ) OR ( j >= SIZE( s ) ) THEN EXIT END;
    c := s[ j ];
    IF c = 0C THEN EXIT END;
    b.s^[ i ] := c;
    INC( i );
    INC( j );
  END;
  b.l := i;
  IF i < b.m THEN b.s^[ i ] := 0C END;
END WrStr;

PROCEDURE WrStrAdj( VAR b: TBuffer; s-: ARRAY OF CHAR; w: INTEGER );
VAR
  l: CARDINAL;
  a: INTEGER;
BEGIN
  l := Str.Length( s );
  a := ABS( w ) - INTEGER( l );
  IF ( a < 0 ) & b.c.c THEN
    WrCharRep( b, '?', ABS( w ) );
    RETURN;
  END;
  IF ( w > 0 ) & ( a > 0 ) THEN WrCharRep( b, b.c.p, a ) END;
  WrStr( b, s );
  IF ( w < 0 ) & ( a > 0 ) THEN WrCharRep( b, b.c.s, a ) END;
END WrStrAdj;


PROCEDURE Char( d: CARDINAL ): CHAR;
BEGIN
  IF d < 0AH THEN
    RETURN CHR( d - 00H + ORD( '0' ) );
  ELSE
    RETURN CHR( d - 0AH + ORD( 'A' ) );
  END;
END Char;

PROCEDURE CardToStr( x: Types.TLngCard; VAR s: ARRAY OF CHAR; b: CARDINAL );
VAR
  t: ARRAY [0..31] OF CHAR;
  i, j: CARDINAL;
BEGIN
  i := 0;
  REPEAT
    t[ i ] := Char( CARDINAL( x MOD Types.TLngCard( b ) ) );
    x := x DIV Types.TLngCard( b );
    INC( i );
  UNTIL ( x = 0 ) OR ( i >= SIZE( t ) );
  j := 0;
  WHILE i > 0 DO
    DEC( i );
    s[ j ] := t[ i ];
    INC( j );
  END;
  IF j < SIZE( s ) THEN s[ j ] := 0C END;
END CardToStr;

PROCEDURE IntToStr( x: Types.TLngInt; VAR s: ARRAY OF CHAR );
BEGIN
  IF x >= 0 THEN
    CardToStr( Types.TLngCard( x ), s, 10 );
  ELSE
    CardToStr( Types.TLngCard( -x ), s, 10 );
    Str.Prepend( s, '-' );
  END;
END IntToStr;


PROCEDURE WrLngCard( VAR b: TBuffer; x: Types.TLngCard; w: INTEGER );
VAR
  s: ARRAY [0..15] OF CHAR;
BEGIN
  CardToStr( x, s, 10 );
  WrStrAdj( b, s, w );
END WrLngCard;

PROCEDURE WrCard( VAR b: TBuffer; x: Types.TCard; w: INTEGER );
BEGIN
  WrLngCard( b, Types.TLngCard( x ), w );
END WrCard;

PROCEDURE WrShtCard( VAR b: TBuffer; x: Types.TShtCard; w: INTEGER );
BEGIN
  WrLngCard( b, Types.TLngCard( x ), w );
END WrShtCard;


PROCEDURE WrLngHex( VAR b: TBuffer; x: Types.TLngCard; w: INTEGER );
VAR
  s: ARRAY [0..7] OF CHAR;
BEGIN
  CardToStr( x, s, 10H );
  WrStrAdj( b, s, w );
END WrLngHex;

PROCEDURE WrHex( VAR b: TBuffer; x: Types.TCard; w: INTEGER );
BEGIN
  WrLngHex( b, Types.TLngCard( x ), w );
END WrHex;

PROCEDURE WrShtHex( VAR b: TBuffer; x: Types.TShtCard; w: INTEGER );
BEGIN
  WrLngHex( b, Types.TLngCard( x ), w );
END WrShtHex;


PROCEDURE WrLngInt( VAR b: TBuffer; x: Types.TLngInt; w: INTEGER );
VAR
  s: ARRAY [0..15] OF CHAR;
BEGIN
  IntToStr( x, s );
  WrStrAdj( b, s, w );
END WrLngInt;

PROCEDURE WrInt( VAR b: TBuffer; x: Types.TInt; w: INTEGER );
BEGIN
  WrLngInt( b, Types.TLngInt( x ), w );
END WrInt;

PROCEDURE WrShtInt( VAR b: TBuffer; x: Types.TShtInt; w: INTEGER );
BEGIN
  WrLngInt( b, Types.TLngInt( x ), w );
END WrShtInt;


PROCEDURE WrSize( VAR b: TBuffer; x: CARDINAL; w: INTEGER );
BEGIN
  WrLngCard( b, Types.TLngCard( x ), w );
END WrSize;


PROCEDURE WrLn( VAR b: TBuffer );
BEGIN
  WrChar( b, cCR );
  WrChar( b, cLF );
END WrLn;

END SO.
