(* real expression parser *)
(* solyga@gmx.de, 2025-08-29 *)
IMPLEMENTATION MODULE RP;

IMPORT Lib, Str, IO, Config;
FROM RS IMPORT Read, TSymbol, TPosition, sym, pos, num, OutStr;
FROM Reals IMPORT Inc, Dec, Mpl, Dvd, Neg;
FROM Reals IMPORT MkStr, TValue;


PROCEDURE Err( s-: ARRAY OF CHAR );
BEGIN
  DEC( pos );
  IO.WrStr( '(' );
  IO.WrCard( pos, 1 );
  IO.WrStr( ') Parser error: ' );
  IO.WrStr( s );
  IO.WrStr( '.' );
  IO.WrLn();
  OutStr();
  (* show position -- function requires tab to be an invalid char ! *)
  IO.WrCharRep( '_', pos );
  IO.WrChar( '^' );
  IO.WrLn();
  HALT;
END Err;

(* synt = expr .
 * expr = [ "+" |"-" ] term { ( "+" | "-" ) term } .
 * term = fact { ( "*" | "/" ) fact } .
 * fact = number | "(" expr ")" .
 *)

PROCEDURE Expression( VAR val: TValue );

  PROCEDURE Factor( VAR val: TValue );
  BEGIN
    IF sym = sNum THEN
      val := num; Read();
    ELSIF sym = sLPar THEN
      Read(); Expression( val );
      IF sym = sRPar THEN Read() ELSE Err( 'Expected operator or ")"' ) END;
    ELSE
      Err( 'Expected number or "("' );
    END;
  END Factor;

  PROCEDURE Term( VAR val: TValue );
  VAR
    op: TSymbol;
    x: TValue;
  BEGIN
    Factor( val );
    WHILE ( sym = sMul ) OR ( sym = sDiv ) DO
      op := sym; Read(); Factor( x );
      IF op = sMul THEN Mpl( val, x ) ELSE Dvd( val, x ) END;
    END;
  END Term;

VAR
  op: TSymbol;
  x: TValue;
BEGIN
  IF ( sym = sPlus ) OR ( sym = sMinus ) THEN
    op := sym; Read(); Term( val );
    IF op = sMinus THEN Neg( val ) END;
  ELSE
    Term( val );
  END;
  WHILE ( sym = sPlus ) OR ( sym = sMinus ) DO
    op := sym; Read(); Term( x );
    IF op = sPlus THEN Inc( val, x ) ELSE Dec( val, x ) END;
  END;
END Expression;

PROCEDURE Run();
VAR
  val: TValue;
  str: ARRAY [0..SIZE(Config.data.str)-1] OF CHAR;
BEGIN
  Read();
  Expression( val );
  IF sym # sEOS THEN Err( 'Expected operator or EOS' ) END;

  IF ~ MkStr( str, val, Config.data.prc ) THEN
    Err( 'BUG: Output conversion failed' );
  END;
  IO.WrStr( str );
  IO.WrLn();
END Run;

END RP.
