(* large bitsets, solyga@gmx.de, 2025-09-17 *)
IMPLEMENTATION MODULE LS;

FROM SYSTEM IMPORT BYTE;
IMPORT Types, Lib, Lib2;


PROCEDURE Fatal( s-: ARRAY OF CHAR );
BEGIN
  Lib.FatalError( s );
  HALT;
END Fatal;


TYPE
  TSht = Types.TShtSet;


PROCEDURE Inc0( VAR x: BYTE; y: BYTE );
BEGIN
  x := BYTE( TSht( x ) + TSht( y ) );
END Inc0;

PROCEDURE Dec0( VAR x: BYTE; y: BYTE );
BEGIN
  x := BYTE( TSht( x ) - TSht( y ) );
END Dec0;

PROCEDURE Mpl0( VAR x: BYTE; y: BYTE );
BEGIN
  x := BYTE( TSht( x ) * TSht( y ) );
END Mpl0;

PROCEDURE Dvd0( VAR x: BYTE; y: BYTE );
BEGIN
  x := BYTE( TSht( x ) / TSht( y ) );
END Dvd0;


<* PUSH *> <* CHECKINDEX - *> <* COVERFLOW - *> <* CHECKRANGE - *>
<* POP *>
PROCEDURE Len( x-: ARRAY OF BYTE ): CARDINAL;
VAR
  l: CARDINAL;
BEGIN
  l := SIZE( x );
  WHILE ( l > 1 ) & ( x[l-1] = BYTE(0) ) DO DEC( l ) END;
  RETURN l;
END Len;


PROCEDURE Clr( VAR x: ARRAY OF BYTE );
BEGIN
  Lib2.Fill( x, 0C );
END Clr;

PROCEDURE Set( VAR x: ARRAY OF BYTE );
BEGIN
  Lib2.Fill( x, 0FFH );
END Set;

PROCEDURE Neg( VAR x: ARRAY OF BYTE );
VAR
  i: CARDINAL;
BEGIN
  FOR i := 0 TO SIZE( x ) - 1 DO
    Dvd0( x[i], 0FFH );
  END;
END Neg;


PROCEDURE Inc( VAR x: ARRAY OF BYTE; y-: ARRAY OF BYTE );
VAR
  l, i: CARDINAL;
BEGIN
  l := Len( y );
  FOR i := 0 TO l - 1 DO
    IF i >= SIZE( x ) THEN Fatal( 'LS FATAL: Inc overflow' ) END;
    Inc0( x[i], y[i] );
  END;
  (* keep remaining x *)
END Inc;

PROCEDURE Dec( VAR x: ARRAY OF BYTE; y-: ARRAY OF BYTE );
VAR
  l, i: CARDINAL;
BEGIN
  l := Len( y );
  FOR i := 0 TO l - 1 DO
    IF i >= SIZE( x ) THEN (* virt. zeros kept *) RETURN END;
    Dec0( x[i], y[i] );
  END;
  (* keep remaining x *)
END Dec;

PROCEDURE Mpl( VAR x: ARRAY OF BYTE; y-: ARRAY OF BYTE );
VAR
  l, i: CARDINAL;
BEGIN
  l := Len( y ); i := 0;
  WHILE i < l DO
    IF i >= SIZE( x ) THEN (* virt. zeros kept *) RETURN END;
    Mpl0( x[i], y[i] ); INC( i );
  END;
  WHILE i < SIZE( x ) DO x[i] := BYTE( 0 ); INC( i ) END;
END Mpl;

PROCEDURE Dvd( VAR x: ARRAY OF BYTE; y-: ARRAY OF BYTE );
VAR
  l, i: CARDINAL;
BEGIN
  l := Len( y );
  FOR i := 0 TO l - 1 DO
    IF i >= SIZE( x ) THEN Fatal( 'LS FATAL: Dvd overflow' ) END;
    Dvd0( x[i], y[i] );
  END;
  (* keep remaining x *)
END Dvd;

END LS.
