IMPLEMENTATION MODULE Sets;

IMPORT LC;


PROCEDURE Char( x: TSht ): CHAR;
BEGIN
  IF x < 10 THEN
    RETURN CHR( x + ORD('0') );
  ELSE
    RETURN CHR( x - 10 + ORD('A') );
  END;
END Char;

PROCEDURE Invert( VAR s: ARRAY OF CHAR; l: CARDINAL );
VAR
  i, j: CARDINAL;
  c: CHAR;
BEGIN
  IF l > SIZE( s ) THEN l := SIZE( s ) END;
  IF l < 2 THEN RETURN END;
  FOR i := 0 TO l DIV 2 - 1 DO
    j := l - 1 - i;
    c := s[ i ]; s[ i ] := s[ j ]; s[ j ] := c;
  END;
END Invert;

PROCEDURE MkStr( VAR s: ARRAY OF CHAR; x: TValue; b: TSht ): BOOLEAN;
VAR
  l: CARDINAL;

  PROCEDURE Put( c: CHAR ): BOOLEAN;
  BEGIN
    IF l >= SIZE( s ) THEN RETURN FALSE END;
    s[ l ] := c;
    INC( l );
    RETURN TRUE;
  END Put;

VAR
  r: TSht;
BEGIN
  IF ( b < bMin ) OR ( b > bMax ) THEN RETURN FALSE END;
  l := 0;
  REPEAT
    IF ~ LC.Dvd( x, b, r ) OR ~ Put( Char(r) ) THEN RETURN FALSE END;
  UNTIL LC.Len0( x ) = 0;
  IF l < SIZE( s ) THEN s[ l ] := 0C END;
  Invert( s, l );
  RETURN TRUE;
END MkStr;

END Sets.
