(* cardinal scanner *)
(* solyga@gmx.de, 2025-09-14 *)
IMPLEMENTATION MODULE CS;

IMPORT Str, IO, Config, LC;
IMPORT Types, Lib2;

VAR
  len: CARDINAL;
  idx: CARDINAL;
  chr: CHAR;


PROCEDURE Err( s-: ARRAY OF CHAR );
BEGIN
  DEC( idx );
  IO.WrStr( '(' );
  IO.WrCard( idx, 1 );
  IO.WrStr( ') Scanner error: ' );
  IO.WrStr( s );
  IO.WrStr( '.' );
  IO.WrLn();
  OutStr();
  (* show position -- function requires tab to be an invalid char ! *)
  IO.WrCharRep( '_', idx );
  IO.WrChar( '^' );
  IO.WrLn();
  HALT;
END Err;


PROCEDURE Get();
BEGIN
  IF idx < len THEN
    chr := Config.data.str[ idx ];
    INC( idx );
  ELSIF idx = len THEN
    chr := 0C;
    INC( idx );
  ELSE
    chr := 0C;
  END;
END Get;

PROCEDURE Alpha(): BOOLEAN;
BEGIN
  RETURN ( '0' <=     chr  ) & (     chr  <= '9' ) OR
         ( 'A' <= CAP(chr) ) & ( CAP(chr) <= 'Z' );
END Alpha;

PROCEDURE Number();
CONST TSht ::= Types.TShtCard;

  PROCEDURE Digit( c: CHAR ): TSht;
  BEGIN
    c := CAP( c );
    CASE c OF
    | '0'..'9': RETURN ORD( c ) - ORD( '0' );
    | 'A'..'Z': RETURN ORD( c ) - ORD( 'A' ) + 10;
    ELSE
      RETURN ORD( 'Z' ) - ORD( 'A' ) + 10 + 1;
    END;
  END Digit;

VAR
  b, d: TSht;
BEGIN
  b := Config.data.bi;
  Lib2.Fill( num, 0C );
  REPEAT
    d := Digit( chr );
    IF d >= b THEN Err( 'Invalid digit' ) END;
    IF ~ LC.Mpl( num, b ) OR ~ LC.Inc( num, d ) THEN Err( 'Number too large' ) END;
    Get();
  UNTIL ~ Alpha();
END Number;

PROCEDURE Read();
BEGIN
  LOOP (* ignore control characters except EOS *)
    IF chr <= ' ' THEN
      IF chr = 0C THEN EXIT END;
      Get();
    ELSIF chr >= 177C THEN
      Get();
    ELSE
      EXIT;
    END;
  END;
  pos := idx;
  CASE chr OF
  | 0C : sym := sEOS;
  | '(': sym := sLPar; Get();
  | ')': sym := sRPar; Get();
  | '+': sym := sPlus; Get();
  | '-': sym := sMinus; Get();
  | '*': sym := sMul; Get();
  | '/': sym := sDiv; Get();
  | '%': sym := sMod; Get();
  (*
  | '~': sym := sNeg; Get();
  *)
  ELSE
    IF Alpha() THEN
      sym := sNum; Number();
    ELSE
      Err( 'Invalid character' )
    END;
  END;
END Read;

PROCEDURE OutStr();
BEGIN
  IO.WrStr( Config.data.str ); IO.WrLn();
END OutStr;

BEGIN
  sym := sNull;
  pos := 0;
  Lib2.Fill( num, 0C );
  len := Str.Length( Config.data.str );
  idx := 0;
  chr := 0C;
  Get();
END CS.
