(* large cardinals - general conversions *)
(* solyga@gmx.de, 2022-11-18 *)
IMPLEMENTATION MODULE LCC;

FROM SYSTEM IMPORT BYTE;
IMPORT Types, Str, Lib2;
IMPORT LC;

TYPE
  TSht = Types.TShtCard;


PROCEDURE Digit( c: CHAR ): TSht;
BEGIN
  c := CAP( c );
  CASE c OF
  | '0'..'9': RETURN ORD( c ) - ORD( '0' );
  | 'A'..'Z': RETURN ORD( c ) - ORD( 'A' ) + 10;
  ELSE
    RETURN bMax;
  END;
END Digit;

PROCEDURE MkCard( VAR x: ARRAY OF BYTE; s-: ARRAY OF CHAR; b: TSht ): BOOLEAN;

  PROCEDURE Eval( VAR x: TSht; c: CHAR ): BOOLEAN;
  BEGIN
    x := Digit( c );
    RETURN x < b;
  END Eval;

VAR
  i, l: CARDINAL;
  y: TSht;
BEGIN
  IF ( b < bMin ) OR ( b > bMax ) THEN RETURN FALSE END;
  l := Str.Length( s );
  IF l = 0 THEN RETURN FALSE END;
  Lib2.Fill( x, 0 );
  FOR i := 0 TO l - 1 DO
    IF ~ Eval( y, s[i] ) OR ~ LC.Mpl( x, b ) OR ~ LC.Inc( x, y ) THEN RETURN FALSE END;
  END;
  RETURN TRUE;
END MkCard;


PROCEDURE Char( x: TSht ): CHAR;
BEGIN
  IF x < 10 THEN
    RETURN CHR( x + ORD('0') );
  ELSE
    RETURN CHR( x - 10 + ORD('A') );
  END;
END Char;

PROCEDURE Invert( VAR s: ARRAY OF CHAR; l: CARDINAL );
VAR
  i, j: CARDINAL;
  c: CHAR;
BEGIN
  IF l > SIZE( s ) THEN l := SIZE( s ) END;
  IF l < 2 THEN RETURN END;
  FOR i := 0 TO l DIV 2 - 1 DO
    j := l - 1 - i;
    c := s[ i ]; s[ i ] := s[ j ]; s[ j ] := c;
  END;
END Invert;

PROCEDURE MkStr( VAR s: ARRAY OF CHAR; x: ARRAY OF BYTE; b: TSht ): BOOLEAN;
VAR
  l: CARDINAL;

  PROCEDURE Put( c: CHAR ): BOOLEAN;
  BEGIN
    IF l >= SIZE( s ) THEN RETURN FALSE END;
    s[ l ] := c;
    INC( l );
    RETURN TRUE;
  END Put;

VAR
  r: TSht;
BEGIN
  IF ( b < bMin ) OR ( b > bMax ) THEN RETURN FALSE END;
  l := 0;
  REPEAT
    IF ~ LC.Dvd( x, b, r ) OR ~ Put( Char(r) ) THEN RETURN FALSE END;
  UNTIL LC.Len0( x ) = 0;
  IF l < SIZE( s ) THEN s[ l ] := 0C END;
  Invert( s, l );
  RETURN TRUE;
END MkStr;

END LCC.
